/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */




#ifndef __SLCATEGORYEDIT_H__
#define __SLCATEGORYEDIT_H__

#include <sl/slcategories.h>
#include <sl/slcategoryeditbase_p.h>
#include <qarray.h>

using namespace SlCategory;

class SlCategoryEditPrivate;

#include <qmessagebox.h>
#include <qlineedit.h>
#include <qdialog.h>
class SlCategoryDialog : public QDialog
{
  Q_OBJECT

public:
  SlCategoryDialog(QWidget *,const QString &, const QString&, const QString&,
				   SlCategoryEditPrivate*);

  QString str;

protected slots:
	void reject();
	void done(int);

private:
  QLineEdit *ed;
  SlCategoryEditPrivate *d;
};

class SlCategoryEdit : public SlCategoryEditBase
{
    Q_OBJECT

public:
    SlCategoryEdit( QWidget *parent = 0, const char *name = 0 );
    SlCategoryEdit( const QArray<int> &vlRecs, const QString &appName,
					const QString &visibleName,
					QWidget *parent = 0, const char *name = 0 );
    ~SlCategoryEdit();
    void setCategories( const QArray<int> &vlRecs,
			const QString &appName, const QString &visibleName );
    QArray<int> newCategories();
    void kludge();

protected:
    void accept();
	void resizeEvent( QResizeEvent *e );

protected slots:
    void slotAdd();
    void slotRemove();
    void slotSetText( QListViewItem *selected );
    void slotSetGlobal( bool isChecked );
    
    void slotRename();
    
    

private:
    SlCategoryEditPrivate *d;

    
	QString oldText;
    
};

QString categoryFileName();

#endif
