/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */




#ifndef __SLCATEGORYSELECT_H__
#define __SLCATEGORYSELECT_H__

#include <qcombobox.h>
#include <qhbox.h>
#include <qstring.h>
#include <qarray.h>
#include <sl/slcategories.h>

using namespace SlCategory;

extern QString categoryFileName();

class QToolButton;

class SlCategoryComboPrivate;
class SlCategoryCombo : public QComboBox
{
    Q_OBJECT

public:
    SlCategoryCombo( QWidget *parent, const char* name = 0 );
    ~SlCategoryCombo();

    int currentCategory() const;
    void setCurrentCategory( int id );
    
    void initCombo( const QArray<int> &recCats, const QString &appName );
    void initCombo( const QArray<int> &recCats, const QString &appName,
		    const QString &visibleName  );

    
    QArray<int> initComboWithRefind( const QArray<int> &recCats, const QString &appName );
    
signals:
    void sigCatChanged( int newUid );

private slots:
    void slotValueChanged( int );

private:
    void setCurrentText( const QString &str );
    SlCategoryComboPrivate *d;
};

class SlCategorySelectPrivate;
class SlCategorySelect : public QHBox
{
    Q_OBJECT
public:
    

    SlCategorySelect( QWidget *parent = 0, const char *name = 0 );

    SlCategorySelect( const QArray<int> &vlCats, const QString &appName,
					  QWidget *parent = 0, const char *name = 0 );
    SlCategorySelect( const QArray<int> &vlCats, const QString &appName,
					  const QString &visibleName, QWidget *parent = 0,
					  const char *name = 0 );

    ~SlCategorySelect();

    const QArray<int> &currentCategories() const;
    int currentCategory() const;
    void setCurrentCategory( int newCatUid );
    
    
    

    
#if 0
    void setCategories( const QArray<int> &vlCats, const QString &appName );
    
    void setCategories( const QArray<int> &vlCats, const QString &appName,
			const QString &visibleName );
#else
    QString setCategories( const QArray<int> &vlCats, const QString &appName );
    QString setCategories( const QArray<int> &vlCats, const QString &appName,
			const QString &visibleName );
#endif
    
    
    void setRemoveCategoryEdit( bool remove );
    void setAllCategories( bool add );

    void setFixedWidth(int width);

signals:
    void signalSelected( int );

private slots:
    void slotDialog();
public slots:
    void slotNewCat( int id );

private:
    void init();
    QString mStrAppName;
    SlCategoryCombo *cmbCat;
    QToolButton *cmdCat;
    SlCategorySelectPrivate *d;
};

#endif
