/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */



#ifndef _SLDBLISTVIEW_H_INCLUDED
#define _SLDBLISTVIEW_H_INCLUDED

#include <qobject.h>
#include <sl/sllistview.h>
#include <sl/slzdtm.h>

using namespace SlZDtm;

struct SlDbListViewColumn {
	uchar name[4];
	QString title;
};
typedef QValueList<SlDbListViewColumn> SlDbListViewColumnList;

class SlDbListViewPrivate;
class SlDbListView : public SlListView
{
	Q_OBJECT
public:
	SlDbListView(QWidget *parent,const char *name=0);
	~SlDbListView();

	void setDb(SlZDataManager *zdtm);
	void setCurrentCardId(CardId cardId);
	void setColumns(const SlDbListViewColumnList &columns);
	CardId currentCardId(SlListViewItem *item=NULL) const;
	void update(CardId cardId=0);
	bool deleteItem(CardId cardId);
	void sort(int column,bool isAscendent);
protected:
	QString itemText(int lineNo,int column) const;

private slots:
	void headerClicked(int column);	
	void systemMessage(const QCString &msg,const QByteArray &data);

private:
	SlListViewItem* findCard(CardId cardId);
	void updateSortIndicator();
	void setSortInfo();
	SlDbListViewPrivate *p;
};



#endif 
