/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */

#ifndef SLLISTVIEW_H
#define SLLISTVIEW_H

#include <qlistview.h>
#include <qpixmap.h>

class SlListViewItem : public QListViewItem
{
public:
	SlListViewItem(QListView *);
	~SlListViewItem();

    virtual void paintCell( QPainter *, const QColorGroup & cg,
							int column, int width, int alignment );

	virtual int lineNo();

protected:
	
	virtual QString itemText( int lineNo, int column) const;
	virtual const QPixmap* itemPixmap( int lineNo, int column) const;
};


class SlCheckListItem : public QCheckListItem
{
public:
	SlCheckListItem(QListView *,Type = Controller);
	~SlCheckListItem();

	virtual void paintCell( QPainter *, const QColorGroup & cg,
							int column, int width, int alignment );

	virtual int lineNo();

protected:
	
	virtual QString itemText( int lineNo, int column) const;
	virtual const QPixmap* itemPixmap( int lineNo, int column) const;

private:
	void paintTextCell( QPainter *, const QColorGroup & cg,
						int column, int width, int alignment );

};


class SlListViewPrivate;
class SlListView : public QListView
{
	Q_OBJECT
public:
	SlListView(QWidget*, const char *name=0);
	~SlListView();

	

	virtual QString itemText( int lineNo , int column) const = 0;

	

	virtual const QPixmap* itemPixmap( int lineNo, int column) const;

	void setAllDataNum(int);


	virtual void newItem();
	virtual void deleteItem(QListViewItem *item=0);
	virtual void setFont(const QFont &f);

	void setAutoLineStep(bool isEnable,int step=3);

private:

	SlListViewPrivate *p;
};


#endif
