/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */
#ifndef SLMIMETYPE_H_INCLUDED
#define SLMIMETYPE_H_INCLUDED

#include <qpe/mimetype.h>
#include <qpe/storage.h>
#include <sl/slmimetypesavedialogbase.h>

class SlMimeType : public MimeType
{
public:
	SlMimeType(const QString& s);
	SlMimeType(const DocLnk& dl);
	~SlMimeType();

	QString defaultDirName() const;
	QString defaultDirNameExt(bool) const;
	static QString defaultDirName(const QString&);
	static QString defaultDirNameExt(const QString&,bool);
	QString defaultDirPath() const;
	static QString defaultDirPath(const QString&);
	static QString saveDialog(QWidget *parent,const QString&,const QString&);

protected:
	class mimetypeMap : public QMap<QString,QString> {
	  public:
		mimetypeMap (const QString& mapfile);
		QString findDirName (const QString& type);
	};

	static const char*	def_file;
	static mimetypeMap*	mime_map;
};

class QCheckListItem;
class SlMimeTypeSaveDialog : public SlMimeTypeSaveDialogBase
{
	Q_OBJECT
public:
	SlMimeTypeSaveDialog(QWidget *parent=0,
						 const char *name=0,
						 bool modal=TRUE,WFlags fl=0);
	~SlMimeTypeSaveDialog();
	uint volumeNum() const;
	void setDefaultVolume(const QString&);
	QString selectedVolume();
	
private slots:
	void slotCurrentChanged(QListViewItem*);

private:
	StorageInfo storage;
	uint vNum;
	QCheckListItem *controller;
};

#endif 

