/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */
#ifndef _SLPAINT_H_INCLUDED
#define _SLPAINT_H_INCLUDED

#include <qwidget.h>
#include <qscrollview.h>

#if defined QT_NO_PICTURE
#define ENABLE_UNDO
#endif
#define ENABLE_PARTIAL_DECODE

#define PIXMAP_MAX_WIDTH (1024)
#define PIXMAP_MAX_HEIGHT (768)

struct SlImageEditPrivate;

class SlImageEdit : public QWidget
{
	Q_OBJECT
public:
	SlImageEdit(QWidget *parent=0,const char *name=NULL,WFlags f=0);
	~SlImageEdit();

	

	enum SlImageEditTool {
		
		Pen,
		
		Eraser,
		
		Select,
		
		Scroll,
		
		Line,
		
		Box,
		
		Ellipse
	};
	void setPixmap(QPixmap*);
	void clearPartialInfo();
	void setPartialPixmap(QPixmap*,const QSize&,const QRect&);
	QPixmap *pixmap() const;
	void setMinimumSize(int,int);
	void setTool(SlImageEditTool);
	SlImageEditTool tool() const;
	void setPenAttr(const QPen&);
	void setEraserAttr(const QPen&);
	QPen penAttr() const;
	QPen eraserAttr() const;
	void setPenBrush(const QBrush&);
	void setEraserBrush(const QBrush&);
	QBrush penBrush() const;
	QBrush eraserBrush() const;
	void setPenColor(const QColor&);
	void setPenWidth(uint);
	const QColor& penColor() const;
	uint penWidth() const;
	bool isSelected() const;
	bool cutSelectedImage();
	bool copySelectedImage();
	bool pasteImage();
	bool clearSelectedImage();
#if !defined QT_NO_PICTURE || defined ENABLE_UNDO
	void flushEdit();
	void undo();
	bool isUndoAvailable();
#endif
	bool isModified();
	void editClear();
	bool isTracing();
#if defined(ENABLE_PARTIAL_DECODE)
	bool isPartialPixmap() const;
	QSize partialRealImageSize() const;
	QRect partialImageRect() const;
	void setPartialPixmapEnabled(bool);
#endif
	void setVisible(bool);

signals:
	

	void selected(QRect&);
	

	void dragStart(const QPoint&);
	

	void dragExec(const QPoint&);
	

	void undoStatusChanged(bool);
	

	void modifyStatusChanged(bool);
	

	void scrollFinished();
	

	void pressed(const QPoint &);

	

	void clicked(const QPoint &);

protected:
	void paintEvent(QPaintEvent*);
	void mousePressEvent(QMouseEvent*);
	void mouseMoveEvent(QMouseEvent*);
	void mouseReleaseEvent(QMouseEvent*);

private:
	void drawSelectFrame(const QPaintDevice *,const QRect &);
	bool selectToClipBoard();
	SlImageEditPrivate *p; 
};

struct SlScrollImageEditPrivate;
class SlScrollImageEdit : public QScrollView
{
	Q_OBJECT
public:
	SlScrollImageEdit(QWidget *parent=0,const char *name=NULL,WFlags f=0);
	~SlScrollImageEdit();
	SlImageEdit *image() const;
	bool loadImage(const QString &);
	void clearImage();
	void newImage(int x,int y,const QColor& fillColor=Qt::white);
	bool saveImage(const QString &,const char *format=NULL);
	bool scroll(int,int);
	void scale(double,double,bool isToOrigin=FALSE);
	void scale(int,int);
	bool isScaleAvailable(double,double,bool isToOrigin=FALSE);
	void xFormPixmap(QWMatrix&);
	void fullScreen();
	void normalScreen();
	void normalScreen(bool isNoLoad);
#if 0 
	void resetMinimumSize();
#endif
#if !defined QT_NO_PICTURE || defined ENABLE_UNDO
	bool isUndoAvailable();
#endif
	bool isModified() const;
	ulong orgImageWidth() const;
	ulong orgImageHeight() const;
	ulong scaledWidth() const;
	ulong scaledHeight() const;
	bool isPartialRequired() const;
	void setDialogMode(bool isOn);
	void setEnabledImage(bool isEnabled);

signals:
	

	void keyPressed(QKeyEvent*);
	

	void undoStatusChanged(bool);
	

	void modifyStatusChanged(bool);
	

	void resized(int,int);
	

	void clicked(const QPoint &);

protected:
	void keyPressEvent(QKeyEvent*);
	void resizeEvent(QResizeEvent*);

private slots:
	void slotDragStart(const QPoint&);
	void slotDragExec(const QPoint&);
	void slotScrollFinished();
	
private:
	SlScrollImageEditPrivate *p;
	void updateForImage();
	bool loadPartialImage(const QString&,const QSize&,const QRect&);
	void reloadImage(bool isPaint=TRUE);
	void reloadPartialImage(bool isPaint=TRUE);
	void killFlicker(bool isEnabled);

};

#endif 


