/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */
#ifndef _SLPAINTTRACER_H_INCLUDED
#define _SLPAINTTRACER_H_INCLUDED

#include <qobject.h>
#include <qpainter.h>
#include <qpointarray.h>
#include <qapplication.h>

class SlImageEditTracer : public QObject
{
	Q_OBJECT
public:
	SlImageEditTracer() {}
	~SlImageEditTracer() {}
	QPainter pmPainter;
	QPainter scPainter;
	virtual void begin(QMouseEvent*,QWidget*,QPaintDevice*) {}
	virtual void trace(QMouseEvent*) {}
	virtual void end(QMouseEvent*) {}
	virtual bool isUndoAvailable() { return FALSE; }
	virtual void flush(QPaintDevice*) {}
};

class SlImageEditPen : public SlImageEditTracer
{
	Q_OBJECT
public:
	SlImageEditPen(QPen& p,QBrush& b) 
		: points(1000) {
		pen = p;
		brush = b;
	}
	~SlImageEditPen() {}
	void begin(QMouseEvent*,QWidget*,QPaintDevice*);
	void trace(QMouseEvent*);
	void end(QMouseEvent*);
	bool isUndoAvailable();
	void flush(QPaintDevice*);
private:
	QPoint prevPenPos;
	QPen pen;
	QBrush brush;
	QPointArray points;
	uint pointNum;
	QPaintDevice *pd; 
};

class SlImageEditEraser : public SlImageEditPen
{
	Q_OBJECT
public:
	SlImageEditEraser(QPen& pen,QBrush& brush)
		: SlImageEditPen(pen,brush) {}
};

class SlImageEditSelector : public SlImageEditTracer
{
	Q_OBJECT
public:
	SlImageEditSelector() {}
	~SlImageEditSelector() {}
	QRect selRect;
	bool isValidRect;
	void begin(QMouseEvent*,QWidget*,QPaintDevice*);
	void trace(QMouseEvent*);
	void end(QMouseEvent*);
};

class SlImageEditScroller : public SlImageEditTracer
{
	Q_OBJECT
public:
	SlImageEditScroller() {}
	~SlImageEditScroller() {}
	void begin(QMouseEvent*,QWidget*,QPaintDevice*);
	void trace(QMouseEvent*);
	void end(QMouseEvent*);
signals:
	void dragStart(const QPoint&);
	void dragExec(const QPoint&);
};

class SlImageEditClear : public SlImageEditTracer
{
	Q_OBJECT
public:
	SlImageEditClear() {}
	~SlImageEditClear() {}
	bool isUndoAvailable() { return TRUE; }
	void flush(QPaintDevice*);
	QRect clearRect;
};

class SlImageEditRubberband : public SlImageEditTracer
{
	Q_OBJECT
public:
	SlImageEditRubberband(QPen& p,QBrush& b) {
		pen = p;
		brush = b;
	}
	~SlImageEditRubberband() {}
	void begin(QMouseEvent *e,QWidget *wd,QPaintDevice *pm){
		scPainter.begin(wd);
		scPainter.setPen(QPen(Qt::white,1,
							  Qt::SolidLine));
		scPainter.setRasterOp(Qt::XorROP);
		startPenPos = e->pos();
		isPrevDraw = FALSE;
	}
	void trace(QMouseEvent *e) {
		if(isPrevDraw){
			draw(scPainter,startPenPos,prevPenPos);
		}else{
			isPrevDraw = TRUE;
		}
		draw(scPainter,startPenPos,e->pos());
		prevPenPos = e->pos();
	}
	void end(QMouseEvent *e) {
		if(isPrevDraw){
			draw(scPainter,startPenPos,prevPenPos);
		}
		endPenPos = e->pos();
		scPainter.setPen(pen);
		scPainter.setBrush(brush);
		scPainter.setRasterOp(Qt::CopyROP);
		draw(scPainter,startPenPos,endPenPos);
	}
	bool isUndoAvailable() { return TRUE; }
	void flush(QPaintDevice *p) {
		QPainter painter;

		painter.begin(p);
		painter.setPen(pen);
		painter.setBrush(brush);
		draw(painter,startPenPos,endPenPos);
		painter.end();
	}
	virtual void draw(QPainter&,const QPoint&,const QPoint&) {}
protected:
	QPoint startPenPos,prevPenPos,endPenPos;
	QPen pen;
	QBrush brush;
	bool isPrevDraw;
};

class SlImageEditLine : public SlImageEditRubberband
{
	Q_OBJECT
public:
	SlImageEditLine(QPen& p,QBrush& b) : SlImageEditRubberband(p,b) {}
	void begin(QMouseEvent *e,QWidget *wd,QPaintDevice *pm){
		SlImageEditRubberband::begin(e,wd,pm);
		pen.setCapStyle(Qt::SquareCap);
	}
	void draw(QPainter& painter,const QPoint& s,const QPoint& e) {
		painter.moveTo(s);
		painter.lineTo(e);
	}
};

class SlImageEditBox : public SlImageEditRubberband
{
	Q_OBJECT
public:
	SlImageEditBox(QPen& p,QBrush& b) : SlImageEditRubberband(p,b) {}
	void begin(QMouseEvent *e,QWidget *wd,QPaintDevice *pm){
		SlImageEditRubberband::begin(e,wd,pm);
		pen.setCapStyle(Qt::SquareCap);
	}
	void draw(QPainter& painter,const QPoint& s,const QPoint& e) {
		painter.drawRect(QRect(s,e));
	}
};

class SlImageEditEllipse : public SlImageEditRubberband
{
	Q_OBJECT
public:
	SlImageEditEllipse(QPen& p,QBrush& b) : SlImageEditRubberband(p,b) {}
	void begin(QMouseEvent *e,QWidget *wd,QPaintDevice *pm){
		SlImageEditRubberband::begin(e,wd,pm);
		scPainter.setPen(QPen(Qt::white,2,Qt::SolidLine));
		pen.setCapStyle(Qt::RoundCap);
	}
	void draw(QPainter& painter,const QPoint& s,const QPoint& e) {
		painter.drawEllipse(QRect(s,e));
	}
};

#endif 
