/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */
#ifndef SLSOUNDCONF_H_INCLUDED
#define SLSOUNDCONF_H_INCLUDED

#include <qobject.h>
#include <qstring.h>
#include <qvaluelist.h>

#define SLSOUNDPLAYER_ERROR_NOERROR		0
#define SLSOUNDPLAYER_ERROR_NOWPLAYING	-1
#define SLSOUNDPLAYER_ERROR_CANTPLAY	-2

class SlSoundPlayerPrivate;
class SlSoundPlayer : public QObject
{
public:
	SlSoundPlayer();
	~SlSoundPlayer();
	int startPlay(const QString&);	
	int syncPlay(const QString&);	
	static int play(const QString&,bool block=false);	
	void stop();
protected:
	void timerEvent(QTimerEvent*);
private:
	SlSoundPlayerPrivate *p;
};

class SlSoundConfPrivate;
class SlSoundConf : public QObject
{
public:
	SlSoundConf();
	~SlSoundConf();
	

	enum SoundType{
		
		ScheduleAlarm = 1,
		
		Startup,
		
		Alert,
		
		TimeTone,
		
		Connected,
		
		StartSync,
		
		SambaEvent,
		
		ReceivedMail
	};
	static QValueList<SoundType> soundTypeList();
	static QString soundId(SoundType);
	static QString soundName(SoundType);
	static QString wavFileName(SoundType);
	static void play(SoundType,bool block=FALSE);
	static void setConfig(SoundType,const QString&);
	static void clearConfig(SoundType);
	static void clearConfig();
	static QString defWavFileName(SoundType);
private:
	SlSoundConfPrivate *p;
};
typedef QValueList<SlSoundConf::SoundType> SlSoundTypeList;

#endif 
