/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */

#ifndef _SLZDATABASE_H_INCLUDED
#define _SLZDATABASE_H_INCLUDED

#include <qmap.h>
#include <qobject.h>

#include <sl/slzdtm.h>
#include <sl/slcategories.h>

using namespace SlZDtm;
using namespace SlCategory;

struct SlZdbItemInfo;
class SlZDataBaseItemInfo : public QMap<int,SlZdbItemInfo>
{
public:
	enum ItemType{
		TEXT = 0,
		UCHAR,
		USHORT,
		ULONG,
		COLOR,
		TIME,
		BINARY,
		CATEGORY
	};
	SlZDataBaseItemInfo();
	~SlZDataBaseItemInfo();

	void addItemInfo(int field,const char *itemName,
					 ItemType type,const QString &title, bool isSearchable=true);

	void toSlZdtmItemInfo(SlZDataManagerItemInfo *items) const;
	
	const SlZdbItemInfo itemInfo(int field);
};

class Contact;
class Task;
class Event;

class SlZDataBasePrivate;
class SlZDataBase : public SlZDataManager
{
public:

	
	static const QString addressbookFileName(bool isBase=false);
	static const QString todolistFileName(bool isBase=false);
	static const QString datebookFileName(bool isBase=false);
	static const QString mailInboxFileName(int storage=0);
	static const QString mailOutboxFileName(int storage=0);
	static const QString memoFileName(bool isBase=false);

	
	static const QString addressbookMasterIdx(bool isBase=false);
	static const QString todolistMasterIdx(bool isBase=false);
	static const QString datebookMasterIdx(bool isBase=false);
	static const QString datebookStartIdx(bool isBase=false);
	static const QString datebookEndIdx(bool isBase=false);
	static const QString datebookMultiIdx(bool isBase=false);
	static const QString datebookRepeatIdx(bool isBase=false);
	static const QString mailInboxMasterIdx(int storage=0);
	static const QString mailOutboxMasterIdx(int storage=0);
	static const QString memoMasterIdx(bool isBase=false);

	
	static SlZDataBaseItemInfo addressbookItems();
	static SlZDataBaseItemInfo todolistItems();
	static SlZDataBaseItemInfo datebookItems();
	static SlZDataBaseItemInfo maillistItems();

	
	static bool createAddressbookFile(const SlZDataManagerIndexInfo &indexes);
	static bool createTodolistFile(const SlZDataManagerIndexInfo &indexes);
	static bool createDatebookFile(const SlZDataManagerIndexInfo &indexes);
	static bool createMailInboxFile(const SlZDataManagerIndexInfo &indexes, int storage);
	static bool createMailOutboxFile(const SlZDataManagerIndexInfo &indexes, int storage);
	static bool createMemoFile(const SlZDataManagerIndexInfo &indexes);

	
	enum CategoriesType{
		
		CategoriesXml = 0,
		
		CategoriesZdtm,
		
		CategoriesNone
	};

	
	static bool addAddressbookEntry(SlZDataBase *zdb,
									CardId *cardId,const Contact &cnt,
									CategoriesType type = CategoriesZdtm);
	static bool addTodolistEntry(SlZDataBase *zdb,
								 CardId *cardId,const Task &task,
								 CategoriesType type = CategoriesZdtm);
	static bool addDatebookEntry(SlZDataBase *zdb,
								 CardId *cardId,const Event &event,
								 CategoriesType type = CategoriesZdtm);

	
	static bool addAddressbookEntry(SlZDataBase *zdb,CardId *cardId,
									SlZDataManager *zdtm,CardId card,
									SlCategories *boxCat=0);
	static bool addTodolistEntry(SlZDataBase *zdb,CardId *cardId,
								 SlZDataManager *zdtm,CardId card,
								 SlCategories *boxCat=0);
	static bool addDatebookEntry(SlZDataBase *zdb,CardId *cardId,
								 SlZDataManager *zdtm,CardId card,
								 SlCategories *boxCat=0);


    
	static bool editAddressbookEntry(SlZDataBase *zdb,
									 CardId *cardId,const Contact &cnt,
									 CategoriesType type = CategoriesZdtm);
	static bool editTodolistEntry(SlZDataBase *zdb,
								  CardId *cardId,const Task &task,
								  CategoriesType type = CategoriesZdtm);
	static bool editDatebookEntry(SlZDataBase *zdb,
								  CardId *cardId,const Event &event,
								  CategoriesType type = CategoriesZdtm);

	
	static Contact toContact(SlZDataBase *zdb,CardId cardId,
							 CategoriesType type = CategoriesZdtm);
	static Task toTask(SlZDataBase *zdb,CardId cardId,
					   CategoriesType type = CategoriesZdtm);
	static Event toEvent(SlZDataBase *zdb,CardId cardId, 
						 CategoriesType type = CategoriesZdtm);

	
	static QArray<int> eventCategoryZdtmToXml(const QArray<int> &dtmIds);
	static QArray<int> eventCategoryXmlToZdtm(const QArray<int> &xmlIds);
    

	SlZDataBase(const char *boxFName,const SlZDataBaseItemInfo &items,
				QWidget *parent = NULL,bool isReadOnly=false);
	~SlZDataBase();

	
	
	
	
    

	QString readField(int field,CardId cardId=0);
	QDateTime readTimeField(int field,CardId cardId=0,bool isUtc=false);
	QDate readDateField(int field,CardId cardId=0); 
	int readUcharField(int field,CardId cardId=0);
	int readUshortField(int field,CardId cardId=0);
	int readUlongField(int field,CardId cardId=0);

	bool clearField(int field);
	bool writeField(int field,const char *data,ulong len);
	bool writeField(int field,const QDateTime &time);
	bool writeField(int field,const QDate &date); 
	bool writeField(int field,const QString &data);
	bool writeField(int field,uchar value);
	bool writeField(int field,ushort value);
	bool writeField(int field,ulong value);

	bool sortField(int field,bool isAscendent);
	bool searchField(CardId *cardId,QString string,
					 int field,uchar searchMode,bool isNext=true);

	DataType readFieldType(int field) const;
	int nameToFieldId(int field) const;
	QString itemName(int field) const;

	
	CardId resumeCardId();

private:
	SlZDataBasePrivate *p;
};






namespace ZdbAdrs
{
	

	enum Fields {
		
		Category = 0,
		
		FullName,
		
		Title,
		
		LastName,
		
		FirstName,
		
		MiddleName,
		
		Suffix,
		
		FileAs,
		
		LastNamePronunciation,
		
		FirstNamePronunciation,
		
		FullNamePronunciation,

		
		Company,
		
		CompanyPronunciation,
		
		Department,
		
		JobTitle,
		
		BusinessPhone,
		
		BusinessFax,
		
		BusinessMobile,
		
		BusinessState,
		
		BusinessCity,
		
		BusinessStreet,
		
		BusinessZip,
		
		BusinessCountry,
		
		BusinessWebPage,
		
		Office,
		
		Profession,
		
		Assistant,
		
		Manager,
		
		BusinessPager,		
		
		HomeMobile,	

		
		HomePhone,
		
		HomeFax,
		
		HomeState,
		
		HomeCity,
		
		HomeStreet,
		
		HomeZip,
		
		HomeCountry,
		
		HomeWebPage,

		
		DefaultEmail,
		
		Emails,

		
		Spouse,
		
		Gender,
		
		Birthday,
		
		Anniversary,
		
		Nickname,
		
		Children,

		
		Notes,
		
		Groups

	};
};




namespace ZdbTodo
{
	

	enum Fields {
		
		Category = 0,
		
		StartDate,
		
		DueDate,
		
		FinishDate,		
		
		Mark,
		
		Priority,
		
		Description,
		
		Notes
	};

	
	enum Mark {
		
		Completed = 0,
		
		UnCompleted
	};
};




namespace ZdbDate
{	
	

	enum Fields{
		
		Category = 0,
		
		Description,
		
		Location,
		
		TimeZone,
		
		Note,
		
		StartDateTime,
		
		EndDateTime,
		
		Type,
		
		Alarm,
		
		AlarmTime,
		
		SoundType,
		
		RepeatType,
		
		RepeatFrequency,
		
		RepeatPosition,
		
		RepeatDays,
		
		RepeatHasEndDate,
		
		RepeatEndDate,
		
		AllDayStart,
		
		AllDayEnd,
		
		MultiDate,
	};

	
	enum Type { 
		
		Normal = 0, 
		
		AllDay 
	};

	
    enum Alarm{ 
		
		AlarmOn = 0, 
		
		AlarmOff 
	};

	
    enum SoundType { 
		
		Silent = 0, 
		
		Loud 
	};

	
	enum RepeatType {
		
		Daily = 0,
		
		Weekly,
		
		MonthlyDay,
		
		MonthlyDate,
		
		Yearly
	};

	 enum Days { 
		  MON = 0x01, 
		  TUE = 0x02, 
		  WED = 0x04, 
		  THU = 0x08,                
		  FRI = 0x10, 
		  SAT = 0x20, 
		  SUN = 0x40 
	 };

	 enum MultiType {
	   NonMulti =0,
	   Multi
	 };
};




namespace ZdbMail
{
	

	enum Fields {
		
		InternalId = 0,
		
		Size,
		
		MailType,

		
		MailRead,
		
		Download,
		
		OnServer,
		
		ServerId,

		
		MailSent,
		
		Modify,
		
		Draft,

		
		SelectCheck,
		
		AccountName,
		
		MailBox,
		
		RecvDateTime,
		
		SendDateTime,
		
		TimeZone,
		
		FromAccount,
		
		FromName,
		
		From,
		
		To,
		
		Cc,
		
		Bcc,
		
		Reply,
		
		Subject,
		
		MailBody,
		
		HtmlBody,

		
		EnclosureNum,
		//! źեե°QString 
		ContentAttrribute,
		//! źեե륿סQString 
		ContentType,
		
		EnclosureFile,
		
		Dummy

	};

	
	enum Type {
		
		ReadMail = 0,
		
		SendMail
	};

	
	enum ReadStatus {
		
		UnRead = 0,
		
		Read,
	};

	
	enum SendStatus {
		
		UnSent = 0,
		
		Sent,
	};

	
	enum CheckStatus {
		
		UnChecked = 0,
		
		Checked
	};

	
	enum IsModify {
		
		Modified = 0,
		
		NewMail
	};

	
	enum IsDraft {
		
		UnDraft = 0,
		
		DraftMail
	};

	
	enum Disposal {
		
		UnCompleted = 0,
		
		Completed
	};

};

#endif 
