/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */





#ifndef SLZIPCONVERTOR_H
#define SLZIPCONVERTOR_H

#include <qdialog.h>
#include <qlistbox.h>
#include <qlist.h>

class SlZIPPrivate;
class QPushButton;
class QCheckBox;
class QLabel;

class SLAddressItem
{	
public:
	SLAddressItem(QString &s,QString &c,QString &z,bool isDraw)
		{
			state = s; 
			city = c; 
			zip = z;
			isDrawZip = isDraw;
		}

	QString stateStr(void) const {return state;}
	QString cityStr(void) const {return city;}
	QString zipStr(void) const {return zip;}
	bool drawZip(void) {return isDrawZip;}
private:
	QString state;
	QString city;
	QString zip;
	bool isDrawZip;
};	

typedef QList<SLAddressItem> SlAddressList;
typedef QListIterator<SLAddressItem> SlAddressListIterator;
 
class SlAddressListBox : public QListBox
{
	Q_OBJECT

public:
	SlAddressListBox(QWidget* parent, const char* name = 0);
	~SlAddressListBox();

	void insertAdrsList(SlAddressList &list);

	SLAddressItem* currentAdrItem(void);

	virtual void clear();

protected:

private:
	SlAddressList *adrList;
};

class SlZIPConvertor : public QDialog
{
	Q_OBJECT

public:
	SlZIPConvertor( QWidget* parent=0, bool isShow = TRUE,
					const char* name=0, bool modal = TRUE );
	~SlZIPConvertor();

	bool isExecute();
	enum SearchMode { Zip2Adr,Adr2Zip };
	void setSearchMode(SlZIPConvertor::SearchMode mode);

	void setZip(QString &zipStr);
	void setAddress(QString &adrStr);

	void setStateAdoption(bool isCheck);

	bool isSelectZip(void);
	bool isSelectAddress(void);

	QString selectedZip(void);
	QString selectedState(void);
	QString selectedCity(void); 

	int convertor();

protected:

	bool eventFilter(QObject*, QEvent *e);

private slots:
	void slotZipClicked();
	void slotAdrClicked();
	void slotAdrZipClicked();
	void slotSelectChanged();
	void slotClicked(QListBoxItem*);

private:
	SlZIPPrivate *d;
	
	SlAddressListBox *adrList;
	QPushButton *zipBtn;
	QPushButton *adrBtn;
	QPushButton *zipadrBtn;
	QCheckBox *stateCheck;
	QLabel *zipLabel;

	void init(bool);
	bool settingData();
	void settingAdrsList(SlAddressList &list,bool isDraw);
};


#endif 
