/*  USB Mouse pointer for Qt 
 *  programed by piro
 *
 *  Based on ser_code_ksim v1.1.0
 *  serial port interface for Palm Portable Keyboard
 *  Copyright (C) 2003 
 *  Trap <CXL00145@nifty.com> (linux zaurus SL-C7x0 version)
 *
 *  Based on ser_code.c created by ...
 *    Dan Morris <dmorris@cs.brown.edu> (initial and windows version)
 *    Ralf Ackermann <rac@KOM.tu-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *  First release 2004.12.07 v0.1
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <libgen.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <termio.h>
#include <error.h>

// mouse
#include <linux/fb.h>
#include <asm/page.h>        
#include <sys/mman.h>
// end_mouse

#ifndef errno
extern int errno;
#endif

// Constants

#define TSDEV "/dev/ts"
#define USBMOUSEDEV    "/dev/usbmouse"

static int fd_mouse = -1;

// mouse
static int mode = 0;
static int consolemode = 0;
static int rotatemode = 0;

static FILE *fd_ts;


static int console_fd;
static struct fb_var_screeninfo vinfo;
static struct fb_fix_screeninfo finfo;
static int mapped_memlen;
static int mapped_offset;
static short *mapped_mem;
static short *mapped_mem_start;
static short *mapped_mem_end;

int fb_offset;

// prototypes

void sig_handler( int status );

void close_all( void );


#define POINTERCAL "/etc/pointercal"

static struct qt_cal {
  int ok;
  int a, b, c, d, e, f, s;
} cal;

static struct q_cal {
  int ok;
  double a, b, c, d, e, f, s;
} qcal;

static short pointer[16][16] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001,
                                 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001,
                                 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001,
                                 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001,
                                 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001,
                                 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001,
                                 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001 };

static short prev_image1[16][16];
static short prev_image2[16][16];
static short prev_x,prev_y;
static int st=0;

void mouseon(int x,int y)
{
  int i,j;
  
  x -= 16;
  for (i=0 ; i<16; i++){
    for (j=0 ; j<16; j++){
      if((mapped_mem+i+x+(j+y)*finfo.line_length/2) > mapped_mem_start &&
         (mapped_mem+i+x+(j+y)*finfo.line_length/2) < mapped_mem_end &&
         ( (i + x) < 480 ) && ( (i + x) >= 0 ) && ( (j + y) < 640 ) && ( (j + y) >= 0 )  ){
        if (pointer[15-i][j] != 1) {
          *(mapped_mem+i+x+(j+y)*finfo.line_length/2 ) = pointer[15-i][j];
        }
      }
    }
  }
  
  return;
}

void mouseoff(int x,int y)
{
  int i,j;
  
  x -= 16;
  for (i=0 ; i<16; i++){
    for (j=0 ; j<16; j++){
      if((mapped_mem+i+x+(j+y)*finfo.line_length/2) > mapped_mem_start &&
         (mapped_mem+i+x+(j+y)*finfo.line_length/2) < mapped_mem_end && 
         ( (i + x) < 480 ) && ( (i + x) >= 0 ) && ( (j + y) < 640 ) && ( (j + y) >= 0 ) &&
     *(mapped_mem+i+x+(j+y)*finfo.line_length/2 ) == prev_image2[i][j] ) {  
    *(mapped_mem+i+x+(j+y)*finfo.line_length/2 ) = prev_image1[i][j];
      }
    }
  }
}

void grabrect1(int x,int y)
{
  int i,j;
  
  x -= 16;
  for (i=0 ; i<16; i++){
    for (j=0 ; j<16; j++){
      if((mapped_mem+i+x+(j+y)*finfo.line_length/2) > mapped_mem_start &&
         (mapped_mem+i+x+(j+y)*finfo.line_length/2) < mapped_mem_end &&
         ( (i + x) < 480 ) && ( (i + x) >= 0 ) && ( (j + y) < 640 ) && ( (j + y) >= 0 )  ){
        prev_image1[i][j]=*(mapped_mem+i+x+(j+y)*finfo.line_length/2 );
      }
    }
  }
}

void grabrect2(int x,int y)
{
  int i,j;
  
  x -= 16;
  for (i=0 ; i<16; i++){
    for (j=0 ; j<16; j++){
      if((mapped_mem+i+x+(j+y)*finfo.line_length/2) > mapped_mem_start &&
         (mapped_mem+i+x+(j+y)*finfo.line_length/2) < mapped_mem_end &&
         ( (i + x) < 480 ) && ( (i + x) >= 0 ) && ( (j + y) < 640 ) && ( (j + y) >= 0 )  ){
        prev_image2[i][j]=*(mapped_mem+i+x+(j+y)*finfo.line_length/2 );
      }
    }
  }
}

void loadConfig()
{
  FILE *pcal;
  cal.ok = 0;
  pcal = fopen(POINTERCAL, "r");
  if(pcal == NULL){
    fprintf(stderr, "Warning: cannot open " POINTERCAL ".\n");
  }else{
    int n;
    n = fscanf(pcal, "%d %d %d %d %d %d %d",
               &cal.a, &cal.b, &cal.c, &cal.d, &cal.e, &cal.f, &cal.s);
    qcal.a = cal.a /1000;
    qcal.b = cal.b /1000;
    qcal.c = cal.c /1000;
    qcal.d = cal.d /1000;
    qcal.e = cal.e /1000;
    qcal.f = cal.f /1000;
    qcal.s = cal.s /1000;
    if(n != 7){
      fprintf(stderr, "Warning: " POINTERCAL " is unknown format.\n");
    }else{
      cal.ok = 1;
    }
    fclose(pcal);
  }
  
  
  console_fd = open("/dev/fb0", O_RDWR, 0);
  if ( console_fd < 0 ) {
    return;
  }
  
  if ( ioctl(console_fd, FBIOGET_FSCREENINFO, &finfo) < 0 ) {
    printf("error");
    return;
  }
  
  if ( ioctl(console_fd, FBIOGET_VSCREENINFO, &vinfo) < 0 ) {
    printf("error");
    return;
  }
  
  mapped_offset = (((long)finfo.smem_start) -
                   (((long)finfo.smem_start)&~(PAGE_SIZE-1)));
  mapped_memlen = finfo.smem_len+mapped_offset;
  mapped_mem = (short*)mmap(NULL, mapped_memlen,PROT_READ|PROT_WRITE, MAP_SHARED, console_fd, 0);
  mapped_mem_start = mapped_mem;
  mapped_mem_end = mapped_mem + finfo.smem_len;
  
  close(console_fd);
}

// Control-C ʥϥɥ
void sig_handler( int status )
{
  printf( "SIGNAL(%d) ΤǥݡȤĤƽλޤ\n", status );
  exit( 1 );
}

void close_all( void )
{
  int i;
  long keycode;
  
  if ( fd_mouse != -1 ) {
    close( fd_mouse );
    fd_mouse = -1;
  }
  
  if ( fd_ts != NULL ) {
    fclose( fd_ts );
  }
  
  if(st == 1){
    mouseoff(prev_y,prev_x);
  }
  
}

int main( int argc, char **argv )
{
  int use_mouse = 0;
  int mousecode = 0;
  int mouse_x = 0, mouse_y = 0, mouse_x_dif = 0, mouse_y_dif = 0;
  int mouse_x_sgn = 0, mouse_y_sgn = 0, mouse_x_of = 0, mouse_y_of = 0, mouse_mb = 0;
  int mouse_lb = 0, mouse_rb = 0, raw_x, raw_y; 
  
  unsigned char code[10];
  
  if ( atexit( close_all ) != 0 ) {
  }

  
  signal( SIGINT,  &sig_handler );
  signal( SIGTERM, &sig_handler );
  signal( SIGHUP,  &sig_handler );
  
  //mouse
  loadConfig();
  
  if( (fd_mouse = open(USBMOUSEDEV, O_RDONLY)) == -1)
    exit(1);

  if( (fd_ts = fopen(TSDEV, "w")) == NULL)
    exit(1);

  // daemonize
  if ( argc == 2 && argv[1][0] == '-' && argv[1][1] == 'd' ) {
    daemon( 0, 0 );
  }
  
  for(;;) {
    
    read(fd_mouse, code, 4);
    
    mouse_y_of = (code[0] >> 7) & 0x01;
    mouse_x_of = (code[0] >> 6) & 0x01;
    mouse_y_sgn = (code[0] >> 5) & 0x01;
    mouse_x_sgn = (code[0] >> 4) & 0x01;
    mouse_mb = (code[0] >> 2) & 0x01;
    mouse_rb = (code[0] >> 1) & 0x01;
    mouse_lb = (code[0] >> 0) & 0x01;
    mouse_x_dif = code[1];
    mouse_y_dif = code[2];
    
    //printf("1 %2x 2 %2x 3 %2x 4 %2x\n", code[0], code[1], code[2], code[3]);
    
    mouse_x = mouse_x + mouse_x_dif;
    mouse_y = mouse_y + mouse_y_dif;
    if (mouse_x_sgn)
      mouse_x -= 256;
    if (mouse_y_sgn)
      mouse_y -= 256;
    if(mouse_x > 639)
      mouse_x = 640;
    if(mouse_y > 479)
      mouse_y = 479;
    if(mouse_x < 0)
      mouse_x = 0;
    if(mouse_y < 0)
      mouse_y = 0;
    
    raw_y = (mouse_y * qcal.s * qcal.e - qcal.c * qcal.e) /(qcal.e * qcal.a);
    raw_x = (mouse_x * qcal.s * qcal.a - qcal.a * qcal.f) /(qcal.e * qcal.a);
    //      if(rotatemode == 0){
    fprintf(fd_ts, "%d %d %d 0\n",mouse_lb*500,raw_y,raw_x);
    fflush(fd_ts);
    //      	fprintf(stderr, "%d %d %d 0\n",(mouse_lb+1)*500,raw_x,480-raw_y);
    if(st == 1){
      mouseoff(prev_y,prev_x);
    }
    grabrect1(mouse_y,mouse_x);
    st = 1;
    mouseon(mouse_y,mouse_x);
    grabrect2(mouse_y,mouse_x);
    prev_x =mouse_x;
    prev_y =mouse_y;
    
  }
  exit( 0 );
}

