/*
 * kernel swicher for sl zaurus
 *  Version 0.1 
 *                         piro
 */


#undef __KERNEL__
#undef MODULE
#define __KERNEL__
#define MODULE

#include <linux/kernel.h>
#include <linux/modsetver.h>
#include <linux/module.h>

#include <linux/elf.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/pagemap.h>
#include <linux/file.h>
#include <linux/slab.h>
#include <linux/elf.h>
#include <linux/types.h>
#include <linux/proc_fs.h>
#include <asm/mach/map.h>
#include <asm/memory.h>

#define DEBUG


#define ZBOOTDEV_MAJOR	99
#define ZBOOTDEV_MODE	0222
#define ZBOOTDEV_NAME	"kernelsw"
#define ZBOOTMOD_NAME	"kernelsw"

#define LOADER_ADDR     0xa0fff000
#define LOADER_SIZE     0x800

#define BOOTPARAM_ADDR  0xa0ffe000          // for this bootloader parameter. not for cmdline
#define BOOTPARAM_SIZE  0x800

#define KERNEL_SIZE     1024 * 1024 * 2
#define KERNEL_OFFSET   0xa0008000

#define PARAM_SIZE      0x900
#define PARAM_OFFSET    0xa0000100

#define INITRD_SIZE     1024 * 1024 * 2     //  consistent_alloc can't allocate over 2M bytes
#define INITRD1_OFFSET  0xa1000000
#define INITRD2_OFFSET  0xa1200000

#define NO_IMAGE        0
#define KERNEL_IMAGE    1
#define PARAM_DATA      2
#define INITRD_IMAGE    4
#define BOOT            5

#define P2V(x)          (x+0x20000000)


/* Prototypes */
void	boot(void);
int	init_module(void);
void	cleanup_module(void);

ssize_t	kernelsw_write(struct file *, const char *, size_t, loff_t *);
int	kernelsw_open(struct inode *, struct file *);
int	kernelsw_close(struct inode *, struct file *);

static	struct file_operations fops = {
	0,			/* struct module *owner */
	0,			/* lseek */
	0,			/* read */
	kernelsw_write,		/* write */
	0,			/* readdir */
	0,			/* poll */
	0,			/* ioctl */
	0,			/* mmap */
	kernelsw_open,		/* open */
	0,			/* flush */
	kernelsw_close,		/* release */
	0,			/* sync */
	0,			/* async */
	0,			/* check media change */
	0,			/* revalidate */
	0,			/* lock */
};

static	int isopen;
static	loff_t position;

static	char *addr;

static  uint *bootparam;
static  int bootparam_size = BOOTPARAM_SIZE;
static  dma_addr_t bootparam_phys = 0; /* bootparam phys addr */

static	int *kernel;	
static  int kernel_size = KERNEL_SIZE; 
static  dma_addr_t kernel_phys = 0;    /* kernel phys addr */
MODULE_PARM(kernel_size, "i");

static	int *param;
static  int param_size = PARAM_SIZE; 
static  int use_param = 0;
static  dma_addr_t param_phys = 0;     /* param phys addr */
MODULE_PARM(use_param, "i");

static	int *initrd1;
static	int *initrd2;
static  int initrd_size = INITRD_SIZE; 
static  int use_initrd = 0;
static  int *initrd_tmp;
static  dma_addr_t initrd1_phys = 0; /* initrd image phys addr */
static  dma_addr_t initrd2_phys = 0; /* initrd image phys addr */
MODULE_PARM(use_initrd, "i");

static int kernel26 = 1;
MODULE_PARM(kernel26, "i");

static int mach_type = 0;
MODULE_PARM(mach_type, "i");


static int load_mode = NO_IMAGE;

static void *func;

#if 1
static void *consistent_alloc(int gfp, size_t size, dma_addr_t *dma_handle);
static void *l_consistent_alloc2(int gfp, size_t size, dma_addr_t *dma_handle, int pte);
static void consistent_free(void *vaddr, size_t size, dma_addr_t handle);
#endif

/*

 */

void boot_loader(int param)
{
  
	__asm__ volatile (

		"mov  r2, %0;\n"
				
		/*
		  commandline param copy
		*/
                "ldr  r4, [r2], #4;\n"      // param virt    +0
		"ldr  r3, [r2], #4;\n"      // param offset  +4
		"ldr  r1, [r2], #4;\n"      // param size    +8

    "1:          ldrb r5, [r4], #+1;\n"    // param copy
		"strb r5, [r3], #+1;\n"
		"subs r1, r1, #1;\n"
		"bne  1b;\n"

		/* 
		   kernel image copy
		*/
		"ldr  r4, [r2], #4;\n"      // kernel virt    +12
		"ldr  r3, [r2], #4;\n"      // kernel offset  +16
		"ldr  r1, [r2], #4;\n"      // kernel size    +20

    "2:          ldrb  r5, [r4], #+1;\n"    // param copy
		"strb  r5, [r3], #+1;\n"
		"subs r1, r1, #1;\n"
		"bne  2b;\n"

		/*
		  initrd image copy
		*/
		"ldr  r4, [r2], #4;\n"      // initrd1 virt  +24
		"ldr  r3, [r2], #4;\n"      // initrd1 offset+28
		"ldr  r1, [r2], #4;\n"      // initrd size   +32

    "3:          ldrb  r5, [r4], #+1;\n"    // initrd1 copy
		"strb  r5, [r3], #+1;\n"
		"subs r1, r1, #1;\n"
		"bne  3b;\n"

		"ldr  r4, [r2], #4;\n"      // initrd2 virt  +36
		"ldr  r3, [r2], #4;\n"      // initrd2 offset+40
		"ldr  r1, [r2], #4;\n"      // initrd size   +44

    "4:          ldrb  r5, [r4], #+1;\n"    // initrd2 copy
		"strb  r5, [r3], #+1;\n"
		"subs r1, r1, #1;\n"
		"bne  4b;\n"


		/*
		  kernel boot setting
		*/
		"ldr  r1, [r2], #4;\n"      // mach type    +48
		"ldr  r0, [r2];\n"          // addr         +52
		

		/*
		  cache & MMU setting
		*/

		"mov  r3, #0;\n"
		"mov  r4, #0x78;\n"
		"mcr  15, 0, r3, c1, c0, 0;\n"
		"mcr  15, 0, r4, c8, c7, 0;\n"

		/*
		  boot
		*/

		"mov  pc, r0;\n"
		: : "r"(param) : "r0","r1","r2","r3","r4","r5" );

}



void boot(void)
{
  void (*func)(int) = boot_loader; 
  int i;
  char *sp,*dp;
  int *tmp;
  int cpsr;

	addr = (char *)KERNEL_OFFSET;

	if(mach_type == 0){
	  if (kernel26)
	    mach_type = 423;  // MACH_TYPE_CORGI on kernel 2.6
	  else
	    mach_type = 309;  // MACH_TYPE_CORGI on kernel 2.4
	}

	/*
	  param_struct setting
	  from include/asm-arm/setup.h
	*/
	if(use_param){
	  
	  tmp = param;
	              *tmp = 0x00001000; //  page_size 
	  tmp += 1;   *tmp = 0x00002000; //  nr_pages
	  tmp += 2; 
	  if (use_initrd){
	              *tmp = 0x00000008; //  flags
	  }else {
	              *tmp = 0x0000000d; //  flags
	  }
	    tmp += 1; *tmp = 0x000000ff; //  rootdev
	  
	  if (use_initrd){
	    tmp += 12;*tmp = 0xc1000000; //  initrd_start 
	    tmp += 1; *tmp = 0x00800000; //  initrd_size
	  }

	  param_size = PARAM_SIZE;
	}else{
	  param_size = 1;
	  param_phys = PARAM_OFFSET;
	}

	if(use_initrd){
	  initrd_size = INITRD_SIZE;
	}else {
	  initrd_size = 1;
	  initrd1_phys = INITRD1_OFFSET;
	  initrd2_phys = INITRD2_OFFSET;
	}

	/* 
	   setting param for boot loader 
	*/

	*bootparam++ = P2V(param_phys);     // +0
	*bootparam++ = P2V(PARAM_OFFSET);   // +4
	*bootparam++ = param_size;          // +8
	*bootparam++ = P2V(kernel_phys);    // +12
	*bootparam++ = P2V(KERNEL_OFFSET);  // +16
	*bootparam++ = KERNEL_SIZE;         // +20
	*bootparam++ = P2V(initrd1_phys);   // +24
	*bootparam++ = P2V(INITRD1_OFFSET);  //+28
	*bootparam++ = initrd_size;         // +32
	*bootparam++ = P2V(initrd2_phys);   // +36
	*bootparam++ = P2V(INITRD2_OFFSET); // +40
	*bootparam++ = initrd_size;         // +44
	*bootparam++ = mach_type;           // +48
	*bootparam   = (uint)addr;          // +52  use physical address for boot address
	bootparam -= 13;

	printk("entry addr 0x%x kernel phys 0x%x\n", addr, kernel_phys);
	printk("MACH_TYPE = %d.\n",mach_type);


	__asm__ volatile ("mrs %0, cpsr_all" : "=r" (cpsr));
	cpsr |= 0xc0;  // set FI 
	__asm__ volatile ("msr cpsr_all, %0" :: "r" (cpsr));


	/*
	  copy boot param to BOOTPARAM_ADDR
	*/

	sp = (char *)P2V(bootparam_phys);
	dp = (char *)P2V(BOOTPARAM_ADDR);
	for(i=0; i <BOOTPARAM_SIZE; i++){
	  *dp++ = *sp++;
	}

	/*
	  copy boot loader to LOADER_ADDR
	*/
	
	sp = (char *)func;
	dp = (char *)P2V(LOADER_ADDR);
	for(i=0; i <LOADER_SIZE; i++){
	  *dp++ = *sp++;
	}

	func = (void *)P2V(LOADER_ADDR);
	func(P2V(BOOTPARAM_ADDR));
}



/*
  memory allocation
*/

int mem_alloc(void)
{


	/*                    */
	/* allocate boot param*/
	/*                    */
	bootparam_size = PAGE_ALIGN(bootparam_size);
	bootparam = (int *)consistent_alloc(GFP_KERNEL | GFP_DMA , bootparam_size, &bootparam_phys);

	if (bootparam == NULL){
	  printk(" Failed in boot param allocation. (size=%d)\n", bootparam_size);
	  return -1;
	}
	memset(bootparam, 0x00, bootparam_size);
	printk("%s: boot param address virt %p phys %p size 0x%x.\n",
	       ZBOOTMOD_NAME, bootparam, bootparam_phys, bootparam_size);

	
	/*                   */
	/* allocate kernel   */
	/*                   */
	kernel_size = PAGE_ALIGN(kernel_size);
	kernel = (int *)consistent_alloc(GFP_KERNEL | GFP_DMA , kernel_size, &kernel_phys);

	if (kernel == NULL){
	  printk(" Failed in kernel image allocation. (size=%d)\n", kernel_size);
	    return -1;
	}
	if(kernel_phys < INITRD1_OFFSET){
	  printk("Unfortunately bad memory allocation.\n");
	  return -1;
	}
	memset(kernel, 0x00, kernel_size);
	printk("%s: kernel address virt %p phys %p size 0x%x.\n", 
	       ZBOOTMOD_NAME, kernel, kernel_phys, kernel_size);


	/*                   */
	/* allocate param    */
	/*                   */
	if(use_param == 1){
	  param_size = PAGE_ALIGN(param_size);
	  param = (int *)consistent_alloc(GFP_KERNEL | GFP_DMA , param_size, &param_phys);
	  
	  if (param == NULL){
	    printk(" Failed in param allocation. (size=%d)\n", param_size);
	    return -1;
	  }
	  if(param_phys < INITRD1_OFFSET){
	    printk("Unfortunately bad memory allocation.\n");
	    return -1;
	  }
	  memset(param, 0x00, param_size);
	  printk("%s: param address virt %p phys %p size 0x%x.\n", 
		 ZBOOTMOD_NAME, param, param_phys, param_size);
	}


	/*                   */
	/* allocate initrd   */
	/*                   */
	if(use_initrd == 1){
	  initrd_size = PAGE_ALIGN(initrd_size);
	  initrd1 = (int *)consistent_alloc(GFP_KERNEL | GFP_DMA , initrd_size, &initrd1_phys);
	  
	  if (initrd1 == NULL){
	    printk(" Failed in initrd allocation. (size=%d)\n", initrd_size);
	    return -1;
	  }
	  if(initrd1_phys < INITRD1_OFFSET){
	    printk("Unfortunately bad memory allocation.\n");
	    return -1;
	  }
	  memset(initrd1, 0x00, initrd_size);

	  /* allocate initrd2  */ 
	  initrd2 = (int *)consistent_alloc(GFP_KERNEL | GFP_DMA , initrd_size, &initrd2_phys);
	  if (initrd2 == NULL){
	    printk(" Failed in initrd2 allocation. (size=%d)\n", initrd_size);
	    return -1;
	  }
	  if(initrd2_phys < INITRD1_OFFSET){
	    printk("Unfortunately bad memory allocation.\n");
	    return -1;
	  }
	  memset(initrd2, 0x00, initrd_size);

	  if (initrd1_phys > initrd2_phys){
	    int *tmp;int tmp_phys;

	    tmp     = initrd2;
	    initrd2 = initrd1;
	    initrd1 = tmp;
	    tmp_phys     = initrd2_phys;
	    initrd2_phys = initrd1_phys;
	    initrd1_phys = tmp_phys;
	  }

	  printk("%s: initrd1 address virt %p phys %p size 0x%x.\n",
		 ZBOOTMOD_NAME, initrd1, initrd1_phys, initrd_size);
	  printk("%s: initrd2 address virt %p phys %p size 0x%x.\n",
		 ZBOOTMOD_NAME, initrd2, initrd2_phys, initrd_size);
	}
	


	return 0;
}

/*
 * Initialize the LKM.
 */
int
init_module()
{
	struct proc_dir_entry *entry;
	int rc;

	bootparam = NULL; kernel = NULL; param = NULL; initrd1 = NULL; initrd2 = NULL;

	rc = register_chrdev(ZBOOTDEV_MAJOR, ZBOOTDEV_NAME, &fops);
	if (rc != 0) {
		printk("%s: register_chrdev(%d, ...): error %d\n",
		    ZBOOTMOD_NAME, -rc);
		return 1;
	}

	entry = proc_mknod(ZBOOTDEV_NAME, ZBOOTDEV_MODE | S_IFCHR,
	    &proc_root, MKDEV(ZBOOTDEV_MAJOR, 0));
	if (entry == (struct proc_dir_entry *)0) {
		(void)unregister_chrdev(ZBOOTDEV_MAJOR, ZBOOTDEV_NAME);
		return 1;
	}

	printk("%s: kernelsw/" MACHINE " bootstrap device is %d,0\n",
	    ZBOOTMOD_NAME, ZBOOTDEV_MAJOR);

	if (mem_alloc()){
	  if (bootparam != NULL){
	    consistent_free(bootparam, bootparam_size, bootparam_phys);
	  }
	  if (kernel != NULL){
	    consistent_free(kernel, kernel_size, kernel_phys);
	  }
	  if (param != NULL){
	    consistent_free(param, param_size, param_phys);
	  }
	  if (initrd1 != NULL){
	    consistent_free(initrd1, initrd_size, initrd1_phys);
	  }
	  if (initrd2 != NULL){
	    consistent_free(initrd2, initrd_size, initrd2_phys);
	  }
	  (void)unregister_chrdev(ZBOOTDEV_MAJOR, ZBOOTDEV_NAME);
	  remove_proc_entry(ZBOOTDEV_NAME, &proc_root);
	  
	  return 1;
	}	


	load_mode = KERNEL_IMAGE;

	printk("%s: %s loading mode.\n",
	       ZBOOTMOD_NAME, kernel26 ? "kernel 2.6" : "kernel 2.4");

	return 0;

}

/*
 * Cleanup - undo whatever init_module did.
 */
void
cleanup_module()
{
        if (bootparam != NULL){
	  consistent_free(bootparam, bootparam_size, bootparam_phys);
	}
        if (kernel != NULL){
	  consistent_free(kernel, kernel_size, kernel_phys);
	}
        if (param != NULL){
	  consistent_free(param, param_size, param_phys);
	}
        if (initrd1 != NULL){
	  consistent_free(initrd1, initrd_size, initrd1_phys);
	}
        if (initrd2 != NULL){
	  consistent_free(initrd2, initrd_size, initrd2_phys);
	}

	(void)unregister_chrdev(ZBOOTDEV_MAJOR, ZBOOTDEV_NAME);
	remove_proc_entry(ZBOOTDEV_NAME, &proc_root);

	printk("%s: kernelsw/" MACHINE " bootstrap device unloaded\n",
	    ZBOOTMOD_NAME);
}


ssize_t
kernelsw_write(struct file *f, const char *buf, size_t len, loff_t *offp)
{
        int size;
	int *dist;

	if (load_mode == KERNEL_IMAGE){
	  dist = kernel; size = kernel_size;
	}
	if (load_mode == PARAM_DATA){
	  dist = param + 0x500/4; size = param_size-0x500;
	}
	if (load_mode == INITRD_IMAGE){
	  dist = initrd1; size = initrd_size*2;
	}
	if (load_mode == BOOT){
	  return len;
	}

	if (len < 1)
		return 0;

	if (*offp + len >= size){
	     printk("Failed: image size is too big!\n");
	     return EFBIG;
	}

	if (load_mode != INITRD_IMAGE){
	  memcpy(((char *)dist) + *offp, buf, len);
	}else{
	  if( *offp > initrd_size){
	    memcpy(((char *)initrd2) + *offp - initrd_size, buf, len);
	  }else if((*offp+len) > initrd_size){
	    memcpy(((char *)initrd1) + *offp , buf, initrd_size - *offp);
	    memcpy(((char *)initrd2), buf + initrd_size - *offp, len - (initrd_size - *offp));

	  }else {
	    memcpy(((char *)initrd1) + *offp, buf, len);
	    //	    printk("write initrd1 offp %x buf %x len %x\n", *offp, buf, len);
	  }
	}

	*offp += len;
	if (*offp > position)
		position = *offp;

	return len;
}

int
kernelsw_open(struct inode *ino, struct file *f)
{

	/* XXX superuser check */

	if (isopen)
		return -EBUSY;

	isopen = 1;
	position = 0;

	return 0;
}

int
kernelsw_close(struct inode *ino, struct file *f)
{
	if (isopen) {
	  if(load_mode == BOOT){

	    boot();
	    printk("%s: boot failed\n", ZBOOTDEV_NAME);       

	  }else if (position > 0) {

	    if(load_mode == KERNEL_IMAGE){

	      printk("%s: Kernel image loaded %d bytes\n", ZBOOTDEV_NAME, position);

	      if(param != NULL){
		load_mode = PARAM_DATA;
	      }else if(initrd1 != NULL && initrd2 != NULL){
		load_mode = INITRD_IMAGE;
	      }else {
		load_mode = BOOT;
	      }

	    }else if(load_mode == PARAM_DATA){
	      printk("%s: Param data loaded %d bytes\n", ZBOOTDEV_NAME, position);
	      if(initrd1 !=NULL && initrd2 !=NULL){
		load_mode = INITRD_IMAGE;
	      }else {
		load_mode = BOOT;
	      }

	    }else if(load_mode == INITRD_IMAGE){
	      printk("%s: Initrd image loaded %d bytes\n", ZBOOTDEV_NAME, position);
	      load_mode = BOOT;
	    }
	    
	  }

	  isopen = 0;
	  return 0;
	}

	return -EBUSY;
}


#if 1
//////////////////////////////////////////////
#include <linux/interrupt.h>

/*
 * This allocates one page of cache-coherent memory space and returns
 * both the virtual and a "dma" address to that space.  It is not clear
 * whether this could be called from an interrupt context or not.  For
 * now, we expressly forbid it, especially as some of the stuff we do
 * here is not interrupt context safe.
 *
 * We should allow this function to be called from interrupt context.
 * However, we call ioremap, which needs to fiddle around with various
 * things (like the vmlist_lock, and allocating page tables).  These
 * things aren't interrupt safe (yet).
 *
 * Note that this does *not* zero the allocated area!
 */
static void *consistent_alloc(int gfp, size_t size, dma_addr_t *dma_handle)
{
    return l_consistent_alloc2(gfp, size, dma_handle, L_PTE_CACHEABLE);
}

static void *l_consistent_alloc2(int gfp, size_t size, dma_addr_t *dma_handle, int pte)
{
    struct page *page, *end, *free;
    unsigned long order;
    void *ret;

    /* FIXME */
    if (in_interrupt())
	BUG();

    size = PAGE_ALIGN(size);
    order = get_order(size);

    page = alloc_pages(gfp, order);
    if (!page) {
	printk("size:%d, order:%d\n", size, order);
	goto no_page;
    }

    *dma_handle = page_to_bus(page);
    //ret = __ioremap(page_to_pfn(page) << PAGE_SHIFT, size, 0);
    ret = __ioremap(page_to_pfn(page) << PAGE_SHIFT, size, pte);
    if (!ret) {
	goto no_remap;
    }

    /*
     * free wasted pages.  We skip the first page since we know
     * that it will have count = 1 and won't require freeing.
     * We also mark the pages in use as reserved so that
     * remap_page_range works.
     */
    free = page + (size >> PAGE_SHIFT);
    end  = page + (1 << order);

    for (; page < end; page++) {
	set_page_count(page, 1);
	if (page >= free)
	    __free_page(page);
	else
	    SetPageReserved(page);
    }
    return ret;

 no_remap:
    __free_pages(page, order);
 no_page:
    return NULL;
}

/*
 * free a page as defined by the above mapping.  We expressly forbid
 * calling this from interrupt context.
 */
static void consistent_free(void *vaddr, size_t size, dma_addr_t handle)
{
    struct page *page, *end;

    if (in_interrupt())
	BUG();

    /*
     * More messing around with the MM internals.  This is
     * sick, but then so is remap_page_range().
     */
    size = PAGE_ALIGN(size);
    page = virt_to_page(bus_to_virt(handle));
    end = page + (size >> PAGE_SHIFT);

    for (; page < end; page++)
	ClearPageReserved(page);

    __iounmap(vaddr);
}

#endif
